/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.neapolitan.core.other;

import com.minecraftabnormals.abnormals_core.core.util.DataUtil;
import com.minecraftabnormals.neapolitan.core.NeapolitanConfig;
import com.minecraftabnormals.neapolitan.core.registry.NeapolitanEntities;
import com.minecraftabnormals.neapolitan.core.registry.NeapolitanFeatures;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="neapolitan")
public class NeapolitanGeneration {
    @SubscribeEvent
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        ResourceLocation biome = event.getName();
        Biome.Category category = event.getCategory();
        if (biome == null) {
            return;
        }
        RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)biome);
        if ((category.equals((Object)Biome.Category.JUNGLE) || biome.func_110623_a().contains("rainforest")) && ((Boolean)NeapolitanConfig.COMMON.plantainSpiderSpawning.get()).booleanValue()) {
            event.getSpawns().func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)NeapolitanEntities.PLANTAIN_SPIDER.get(), 120, 3, 5));
        }
        if (category.equals((Object)Biome.Category.PLAINS) && (Integer)NeapolitanConfig.COMMON.strawberryBushGenerationChance.get() > 0) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, NeapolitanFeatures.Configured.PATCH_STRAWBERRY_BUSH);
        }
        if (category.equals((Object)Biome.Category.FOREST) && (Integer)NeapolitanConfig.COMMON.adzukiSproutsGenerationChance.get() > 0) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, NeapolitanFeatures.Configured.PATCH_ADZUKI_SPROUTS);
        }
        if (category.equals((Object)Biome.Category.SAVANNA) && (Integer)NeapolitanConfig.COMMON.vanillaVineGenerationChance.get() > 0) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, NeapolitanFeatures.Configured.PATCH_VANILLA_VINE);
        }
        if (category.equals((Object)Biome.Category.EXTREME_HILLS)) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, NeapolitanFeatures.Configured.MINT_POND);
        }
        if (event.getClimate().field_242460_b.equals((Object)Biome.RainType.RAIN)) {
            if (category.equals((Object)Biome.Category.BEACH) && ((Boolean)NeapolitanConfig.COMMON.bananaPlantBeachGeneration.get()).booleanValue()) {
                event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, NeapolitanFeatures.Configured.BANANA_PLANT_BEACH);
            }
            if (category.equals((Object)Biome.Category.JUNGLE) && ((Boolean)NeapolitanConfig.COMMON.bananaPlantJungleGeneration.get()).booleanValue() && !DataUtil.matchesKeys((ResourceLocation)biome, (RegistryKey[])new RegistryKey[]{Biomes.field_222370_aw}) && !DataUtil.matchesKeys((ResourceLocation)biome, (RegistryKey[])new RegistryKey[]{Biomes.field_222371_ax})) {
                if (!DataUtil.matchesKeys((ResourceLocation)biome, (RegistryKey[])new RegistryKey[]{Biomes.field_150574_L}) && !DataUtil.matchesKeys((ResourceLocation)biome, (RegistryKey[])new RegistryKey[]{Biomes.field_185447_Y})) {
                    event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, NeapolitanFeatures.Configured.BANANA_PLANT_JUNGLE);
                } else {
                    event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, NeapolitanFeatures.Configured.BANANA_PLANT_RARE);
                }
            }
            if (biome.func_110623_a().contains("rainforest") && ((Boolean)NeapolitanConfig.COMMON.bananaPlantJungleGeneration.get()).booleanValue()) {
                if (BiomeDictionary.hasType((RegistryKey)key, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
                    event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, NeapolitanFeatures.Configured.BANANA_PLANT_RARE);
                } else {
                    event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, NeapolitanFeatures.Configured.BANANA_PLANT_VERY_RARE);
                }
            }
        }
    }
}

